ORCA/M Asm65816 2.1.0

0001 59A9              ***********************************************************************************
0002 59A9              *
0003 59A9              *            Copyright Apple Computer, Inc. 1986-92
0004 59A9              *                     All Rights Reserved
0005 59A9              *                    Written by Dan Oliver
0006 59A9              *
0007 59A9              *               *** C O N F I D E N T I A L ***
0008 59A9              *
0009 59A9              *
0010 59A9              *                   Change History:
0011 59A9              *
0012 59A9              * 05 Jan 90         Yee
0013 59A9              *
0014 59A9              * Added icon support for menu items. Added calls SetItemIcon and GetItemIcon.
0015 59A9              *
0016 59A9              * 29 Mar 90         Yee
0017 59A9              * Fix bug in DeleteMenu. The handle being removed was not being unlocked after
0018 59A9              * it was removed.
0019 59A9              *
0020 59A9              * 05 Apr 90
0021 59A9              * Change the way the menu item icons are drawn. I now use DrawIcon instead
0022 59A9              * of PPToPort to draw the icon. To use icons in menu items, the menu mgr
0023 59A9              * now requires that QDAux be started. Also the icon structure used to look
0024 59A9              * like a locInfo record, it's now an icon structure as defined by rIcon.
0025 59A9              *
0026 59A9              * 10 May 90         Yee
0027 59A9              * Fix bug in routine DrawItemIcon.  I now make sure the item has an itemstruct assoc.
0028 59A9              * with it before trying to get the itemstruct.
0029 59A9              *
0030 59A9              * 05 Jul 90         Yee
0031 59A9              * Added the following calls: SetItemStruct ($490F), GetItemStruct ($4A0F),
0032 59A9              * RemoveItemStruct ($4B0F), GetItemFlag2 ($4C0F), SetItemFlag2 ($4D0F)
0033 59A9              *
0034 59A9              * 17-Sep-90         Dave Lyons
0035 59A9              *
0036 59A9              * Removed dependency on all.macros.
0037 59A9              *
0038 59A9              * Note--Call $4E0F, GetItemWidth (Harry's?)
0039 59A9              *
0040 59A9              * 19-Sep-90         Dave Lyons
0041 59A9              *
0042 59A9              * Added GetMItemBlink call ($4F0F).  Version is $8303.
0043 59A9              * Adding MenuGlobal bit to make MenuSelect call InitCursor.
0044 59A9              * (The InitCursor thing doesn't work too well yet--it flickers the cursor.)
0045 59A9              *
0046 59A9              * 27-Sep-90         Dave Lyons
0047 59A9              *
0048 59A9              * Now calls Get640Colors (QD) to get a pointer to the color_patt table
0049 59A9              * instead of hard-coding our own.
0050 59A9              *
0051 59A9              * Put all.macros back.
0052 59A9              *
0053 59A9              * 7-Jan-91          Dave Lyons
0054 59A9              *
0055 59A9              * Moved the G_INITCURSOR check to where it really should be (when we decide
0056 59A9              * the mouse was actually clicked in the menu bar).
0057 59A9              *
0058 59A9              * When blinking a menu item, now I call WaitUntil to wait at least MinMenuBlinkTime
0059 59A9              * since the last blink.
0060 59A9              *
0061 59A9              * 9..10-Jan-91      Dave Lyons
0062 59A9              *
0063 59A9              * Added new call InsertPathMItems for use by Finder, Standard File, Installer.
0064 59A9              *
0065 59A9              * 11-Jan-91         Dave Lyons
0066 59A9              *
0067 59A9              * InsertPathMItems: Added InsertAfter parameter, defined bit 2 of Flags, and
0068 59A9              * reordered parameters.  Cool.
0069 59A9              *
0070 59A9              * 12-Jan-91         Dave Lyons
0071 59A9              *
0072 59A9              * Changes to InsertPathMItems (see comments there).
0073 59A9              *
0074 59A9              * 16-Jan-91         Dave Lyons
0075 59A9              *
0076 59A9              * Fixed up some comments.  Fixed the bug that makes pop-up menus not
0077 59A9              * always hilite menu items (sometimes it just inverts the icon).
0078 59A9              * The problem was popPortData stuffing values into a grafport while
0079 59A9              * fastPort was on.  Added a SetPort after the port stuffing to make
0080 59A9              * QD realize we dicked around with the port.
0081 59A9              *
0082 59A9              * Made a few $E10000 into macro calls.
0083 59A9              *
0084 59A9              * 22-Jan-91         Dave Lyons
0085 59A9              *
0086 59A9              * Fixed drawing an icon in a menu so that it always draws at an even horizontal
0087 59A9              * location.
0088 59A9              *
0089 59A9              * 5-Feb-91          Dave Lyons
0090 59A9              *
0091 59A9              * Fixed a bug in InsertPathMItems where I was disposing of one of the handles
0092 59A9              * that gets passed back to the caller for later disposal.
0093 59A9              *
0094 59A9              * Changed name of GetOSIcon to GetSysIcon.
0095 59A9              *
0096 59A9              * 17-Feb-91         Dave Lyons
0097 59A9              *
0098 59A9              * Optimized some LDA/PHA into PEIs.
0099 59A9              * MenuStartUp now sets the default menu item blink from BRAM $5E bits 3-4.
0100 59A9              *
0101 59A9              * 22-Feb-91         Dave Lyons
0102 59A9              *
0103 59A9              * Skip InsertPathMItems DInfo call if they pass device number $FFFF.
0104 59A9              *
0105 59A9              * 3-Mar-91          Dave Lyons
0106 59A9              *
0107 59A9              * Added MenuKey feature:  If the key is an Apple- key and is not the equivalent
0108 59A9              * for any menu item in the passed menu, then we call SendRequest($0F01) to give
0109 59A9              * system extensions a chance to handle the keypress.
0110 59A9              *
0111 59A9              * 14-Mar-91         Dave Lyons
0112 59A9              *
0113 59A9              * If the MenuKey SendRequest succeeds, I change the event into a null event so
0114 59A9              * the caller doesn't try to handle it any further.
0115 59A9              *
0116 59A9              * 15-May-91         Dave Lyons
0117 59A9              *
0118 59A9              * InsertMenu now returns new error dupMenuID, $0F04, if a menu with the same id
0119 59A9              * already exists in the current menu bar.
0120 59A9              *
0121 59A9              * 25-Jul-91         Dave Lyons
0122 59A9              *
0123 59A9              * Added restrictions to SendRequest($0F01=systemSaysMenuKey): Desk Manager must
0124 59A9              * be active, CDA-events must be postable (for Installer when it disables use
0125 59A9              * of DAs), and we must be dealing with the system menu bar.
0126 59A9              *
0127 59A9              * 26-Aug-91         Dave Lyons
0128 59A9              *
0129 59A9              * HideMenuBar now messes only with SCBs 2 through 9, instead of setting them all
0130 59A9              * to the MasterSCB.
0131 59A9              *
0132 59A9              * SendRequest(systemSaysMenuKey) now has stop-after-one set.
0133 59A9              *
0134 59A9              * 18-Sep-91         Dave Lyons
0135 59A9              *
0136 59A9              * Made HideMenuBar mess with SCBs 0..MenuBarHeight-1, instead of just 2..9.
0137 59A9              * This is for HyperCard IIgs compatibility.
0138 59A9              *
0139 59A9              * 7-Dec-91          Dave Lyons
0140 59A9              *
0141 59A9              * Moved G_INITCURSOR code to 'gotit', where it works without causing cursor flicker.
0142 59A9              * InsertPathMItems:  Added a bcc @noError after first ExpandPath.  Probably dead
0143 59A9              *   code, since this call is intended to always return a buffer-too-small error
0144 59A9              *   and do a second ExpandPath.
0145 59A9              * PopUpMenuSelect now calls get_ids instead of lda [<itemptr] to get the selected
0146 59A9              *   item's id, for compatibility with custom pop-up menus.
0147 59A9              *
0148 59A9              * 8-Feb-92          Dave Lyons
0149 59A9              *
0150 59A9              * Added safety check on top coordinate of menu bar:  MenuSelect refuses to pull
0151 59A9              * down a menu at Y>=150.  Minor optimizations.
0152 59A9              *
0153 59A9              * Version $0303 for 6.0 final.
0154 59A9              *
0155 59A9              ***********************************************************************************
0156 59A9              *
0157 59A9              * 13-Mar-92         Dave Lyons
0158 59A9              *
0159 59A9              * Version $8304 for 6.0.1
0160 59A9              *
0161 59A9              * 4-Jun-92          Dave Lyons
0162 59A9              *
0163 59A9              * DeleteMItem now shrinks menu handle by 12 bytes instead of 10, so we don't
0164 59A9              * waste two bytes every time we delete an item.
0165 59A9              *
0166 59A9              * 25-Mar-93         Dave Lyons
0167 59A9              *
0168 59A9              * In AllocateCache, we now clip the menu height to 200 for computing the size
0169 59A9              * handle needed to save the screen.  We were overflowing the computation for
0170 59A9              * tall pop-up menus.
0171 59A9              *
0172 59A9              * 1-Apr-93          Steve Stephenson
0173 59A9              *
0174 59A9              * Version $0304 for 6.0.1 (final)
0175 59A9              *
0176 59A9              ***********************************************************************************
0177 59A9
0178 59A9
0179 59A9              *******************************************************************************
0180 59A9              *
0181 59A9              PushPortData PROC EXPORT 
0182 59A9              *
0183 59A9              * Description:      This routine will push grafport variables that can be changed
0184 59A9              *                   by menuselect and popupmenuselect. This pushes:
0185 59A9              *                   BkPat
0186 59A9              *                   PnLoc
0187 59A9              *                   pnSize
0188 59A9              *                   pnMode
0189 59A9              *                   pnPat
0190 59A9              *                   pnMask
0191 59A9              *                   pnVis
0192 59A9              *                   fontHandle
0193 59A9              *                   fontID
0194 59A9              *                   fontFlags
0195 59A9              *                   txSize
0196 59A9              *                   txFace
0197 59A9              *                   txMode
0198 59A9              *                   spExtra
0199 59A9              *                   chExtra
0200 59A9              *                   fgColor
0201 59A9              *                   bgColor
0202 59A9              *
0203 59A9              *
0204 59A9              * Inputs:           None
0205 59A9              *
0206 59A9              * Outputs:          All that stuff on the stack!
0207 59A9              *
0208 59A9              * External Refs:
0209 59A9              *
0210 59A9              * Entry Points:
0211 59A9              *
0212 59A9              *******************************************************************************
0213 59A9              *
0214 59A9              * Direct page equates for my stack frame, note that I will leave this data on the
0215 59A9              * stack and take it off with popPortData
0216 59A9              *
0217 59A9              FrameSize equ   $74                     ; 70 bytes of data + grafport pointer
0218 59A9              portPtr  equ   1                        ; the place we will use for our grafport pointer
0219 59A9              LocalPortData equ   portPtr+4           ; storage area for our port pointer
0220 59A9              ;
0221 59A9              ; First set up our stack frame...
0222 59A9 7A                    ply                            ; recover the return address and save it...
0223 59AA 7B                    tdc                            ; get the current dpage
0224 59AB AA                    tax                            ; and save it in <X>
0225 59AC
0226 59AC 3B                    tsc                            ; get the stack pointer
0227 59AD 38                    sec   
0228 59AE E9 74 00              sbc   #FrameSize               ; adjust the stack pointer
0229 59B1 1B                    tcs                            ; make it the new stack pointer and the new
0230 59B2 5B                    tcd                            ; direct page
0231 59B3
0232 59B3 5A                    phy                            ; restore the return address
0233 59B4 DA                    phx                            ; and save the old dpage pointer
0234 59B5
0235 59B5              ; Now get the current grafport pointer
0236 59B5 48                    pha                            ; room for result
0237 59B6 48                    pha   
0238 59B7 A2 04 1C 22           _GetPort                       ;
0239 59BE 68                    pla   
0240 59BF 85 01                 sta   <portPtr                 ; and save the port pointer to our dpage
0241 59C1 68                    pla   
0242 59C2 85 03                 sta   <portPtr+2               ;
0243 59C4
0244 59C4              ; now copy $70 bytes of data to our localportdata area
0245 59C4
0246 59C4 A0 8E 00              ldy   #$8E                     ; last address to copy from
0247 59C7 A2 6E 00              ldx   #$6E                     ; last data to copy
0248 59CA B7 01        @CopyLoop lda   [<portPtr],y            ; get the byte of data
0249 59CC 95 05                 sta   <LocalPortData,x         ; and save it
0250 59CE 88                    dey   
0251 59CF 88                    dey   
0252 59D0 CA                    dex   
0253 59D1 CA                    dex   
0254 59D2 10 F6                 bpl   @CopyLoop
0255 59D4
0256 59D4              ; now that we are done, lets get the proper direct page off the stack and end...
0257 59D4 2B                    pld   
0258 59D5 60                    rts                            ; now leave
0259 59D6
0260 59D6
0261 59D6                       EJECT 
0262 59D6              *******************************************************************************
0263 59D6              *
0264 59D6              PopPortData PROC EXPORT 
0265 59D6              *
0266 59D6              * Description:      This routine will pop grafport variables that can be changed
0267 59D6              *                   by MenuSelect and PopUpMenuSelect.
0268 59D6              *
0269 59D6              *             NOTE: You must have called PushPortData first, and the stack must
0270 59D6              *                   be set to what it was when pushPortData returned.
0271 59D6              *
0272 59D6              *        This pops:
0273 59D6              *                   BkPat
0274 59D6              *                   PnLoc
0275 59D6              *                   pnSize
0276 59D6              *                   pnMode
0277 59D6              *                   pnPat
0278 59D6              *                   pnMask
0279 59D6              *                   pnVis
0280 59D6              *                   fontHandle
0281 59D6              *                   fontID
0282 59D6              *                   fontFlags
0283 59D6              *                   txSize
0284 59D6              *                   txFace
0285 59D6              *                   txMode
0286 59D6              *                   spExtra
0287 59D6              *                   chExtra
0288 59D6              *                   fgColor
0289 59D6              *                   bgColor
0290 59D6              *
0291 59D6              *
0292 59D6              * Inputs:           None
0293 59D6              *
0294 59D6              * Outputs:          All that stuff on the stack!
0295 59D6              *
0296 59D6              * External Refs:
0297 59D6              *
0298 59D6              * Entry Points:
0299 59D6              *
0300 59D6              *******************************************************************************
0301 59D6              *
0302 59D6              * Direct page equates for my stack frame, note that I will leave this data on the
0303 59D6              * stack and take it off with popPortData
0304 59D6              *
0305 59D6              FrameSize equ   $74                     ; 70 bytes of data + grafport pointer
0306 59D6              savedDPage equ   1
0307 59D6              Rtn1     equ   savedDPage+2
0308 59D6              portPtr  equ   Rtn1+2                   ; the place we will use for our grafport pointer
0309 59D6              LocalPortData equ   portPtr+4           ; storage area for our port pointer
0310 59D6              ; first copy $70 bytes of data from our localportdata area to the port
0311 59D6 0B                    phd                            ; save the old dPage
0312 59D7 3B                    tsc                            ; now make the stack the dPage
0313 59D8 5B                    tcd   
0314 59D9
0315 59D9 A0 8E 00              ldy   #$8E                     ; last address to copy from
0316 59DC A2 6E 00              ldx   #$6E                     ; last data to copy
0317 59DF              @CopyLoop  
0318 59DF B5 09                 lda   <LocalPortData,x         ; and save it
0319 59E1 97 05                 sta   [<portPtr],y             ; get the byte of data
0320 59E3 88                    dey   
0321 59E4 88                    dey   
0322 59E5 CA                    dex   
0323 59E6 CA                    dex   
0324 59E7 10 F6                 bpl   @CopyLoop
0325 59E9
0326 59E9              ; Now that we are finished, reset the old dPage and pull all the old shit
0327 59E9              ; off the stack
0328 59E9
0329 59E9              *** added 16-Jan-91 DAL to make this thing work with fastPort on!
0330 59E9              *** Just set the port to what it already is to clear the fastPort
0331 59E9              *** dirty flags & make items always hilite properly. BRC:MS902MSC.
0332 59E9 48                    pha   
0333 59EA 48                    pha   
0334 59EB A2 04 1C 22           _GetPort 
0335 59F2 A2 04 1B 22           _SetPort 
0336 59F9              *** end of 16-Jan-91 DAL fix
0337 59F9
0338 59F9 2B                    pld                            ; restore the directpage
0339 59FA 7A                    ply                            ; save the return address for a sec...
0340 59FB
0341 59FB 3B                    tsc                            ; now adjust the stack pointer
0342 59FC 18                    clc   
0343 59FD 69 74 00              adc   #FrameSize
0344 5A00 1B                    tcs                            ; and resave the stack pointer
0345 5A01 5A                    phy                            ; restore the return address
0346 5A02 60                    rts                            ; now leave
0347 5A03
0348 5A03                       ENDP 
0349 5A03
0350 5A03
0351 5A03              ***********************************************************************************
0352 5A03              *
0353 5A03              * InsertPathMItems -- new call 10-Jan-91 Dave Lyons
0354 5A03              *
0355 5A03              * Description:
0356 5A03              *
0357 5A03              * Takes a word-length pathname string and makes a series of InsertMItem2 calls for
0358 5A03              * you, one for each segment of the pathname.  Each item gets an appropriate
0359 5A03              * little icon next to it, as returned from GetSysIcon (in QD Aux).
0360 5A03              *
0361 5A03              * Inputs:
0362 5A03              *
0363 5A03              * $500F InsertPathMItems(flags: integer; thePath: longint;
0364 5A03              *                        MenuID: integer; AfterItemID: integer;
0365 5A03              *                        StartingItemID: integer; ResultPtr: Ptr);
0366 5A03              *
0367 5A03              * flags             bits 15-5 reserved (use 0)
0368 5A03              *                   bit 4 = the pathname is already fully expanded (no need for me to
0369 5A03              *                           call ExpandPath on it) (not used yet)
0370 5A03              *                   bit 3 = 1=theDevNum is valid, 0=ignored
0371 5A03              *                   bit 2 = 1=use Open folder icons
0372 5A03              *                           0=use Closed folder icons
0373 5A03              *                   bit 1 = reserved (0)
0374 5A03              *                   bit 0 = 0=insert items with Device at bottom
0375 5A03              *                           1=insert items with Device at top
0376 5A03              * thePath           Word-length string--a complete GS/OS pathname.  This string
0377 5A03              *                   is preserved, not munged.
0378 5A03              * theInputDevNum    Device number of the device the pathname is on, if bit 3 of flags is set.
0379 5A03              * MenuID            The MenuID of the menu to insert into (passed to InsertMItem2)
0380 5A03              * AfterItemID       The Menu Item ID to insert AFTER, in the specified menu.
0381 5A03              * StartingItemID    The Menu Item ID for the first item to be inserted (we build
0382 5A03              *                   up sequentially from there).
0383 5A03              * ResultPtr         Pointer to results buffer.
0384 5A03              *                   +000 Word  receives highest menu item ID that was inserted
0385 5A03              *                   +002 Long  receives the itemStructs handle (caller must dispose later)
0386 5A03              *                   +006 Long  receives a handle containing the expanded and munged-up path
0387 5A03              *                              (caller must dispose later)
0388 5A03              *
0389 5A03              ***********************************************************************************
0390 5A03              InsertPathMItems proc export 
0391 5A03
0392 5A03 8B                    phb   
0393 5A04 4B                    phk   
0394 5A05 AB                    plb   
0395 5A06
0396 5A06 0B                    phd   
0397 5A07
0398 5A07 5A                    phy   
0399 5A08 48                    pha                            ;pushed WAP
0400 5A09 48                    pha   
0401 5A0A 48                    pha                            ;pushed space for ItemStructList
0402 5A0B 3B                    tsc   
0403 5A0C 5B                    tcd   
0404 5A0D
0405 5A0D              ItemStructList equ   1
0406 5A0D              MenuWAP  equ   ItemStructList+4
0407 5A0D              oldD     equ   MenuWAP+4
0408 5A0D              oldB     equ   oldD+2
0409 5A0D              rtl1     equ   oldB+1
0410 5A0D              rtl2     equ   rtl1+3
0411 5A0D              ResultPtr equ   rtl2+3
0412 5A0D              theStartingID equ   ResultPtr+4
0413 5A0D              AfterItemID equ   theStartingID+2
0414 5A0D              theMenuID equ   AfterItemID+2
0415 5A0D              theInputDevNum equ   theMenuID+2
0416 5A0D              thePath  equ   theInputDevNum+2
0417 5A0D              theFlags equ   thePath+4
0418 5A0D
0419 5A0D 22 20 5D 02           jsl   DoInsertItems            ;returns error code in A
0420 5A11 AA                    tax   
0421 5A12
0422 5A12 7A                    ply   
0423 5A13 7A                    ply                            ;removed ItemStructList
0424 5A14 7A                    ply   
0425 5A15 7A                    ply                            ;removed WAP
0426 5A16
0427 5A16 2B                    pld   
0428 5A17 AB                    plb   
0429 5A18
0430 5A18 A0 12 00              ldy   #18                      ;strip input parameters from the stack
0431 5A1B 5C 84 01 E1           jml   $e10184
0432 5A1F
0433 5A1F
0434 5A1F              *** DoInsertItems -- do the work, return error in A
0435 5A1F
0436 5A1F 6B           exitError rtl   
0437 5A20
0438 5A20 20 E5 5E     DoInsertItems jsr   ExpandThePath       ;result pointer in thePath if no error
0439 5A23 B0 FA                 bcs   exitError
0440 5A25
0441 5A25              *** We've now got a copy of the fully-expanded pathname at <thePath.
0442 5A25
0443 5A25 20 4D 5E              jsr   GetDeviceID              ;input=thePath, output=A
0444 5A28
0445 5A28              *** Figure out how many items we're going to insert, by simply counting the
0446 5A28              *** colons in the input string
0447 5A28
0448 5A28 A7 1E                 lda   [<thePath]
0449 5A2A 1A                    inc   a
0450 5A2B 1A                    inc   a
0451 5A2C 8D CF 5E              sta   Length
0452 5A2F
0453 5A2F A2 00 00              ldx   #0                       ;number of items
0454 5A32 A0 02 00              ldy   #2
0455 5A35 CC CF 5E     @count   cpy   Length
0456 5A38 B0 0E                 bcs   @counted
0457 5A3A B7 1E                 lda   [<thePath],y
0458 5A3C 29 FF 00              and   #$00ff
0459 5A3F C9 3A 00              cmp   #':'
0460 5A42 D0 01                 bne   @notColon
0461 5A44 E8                    inx   
0462 5A45 C8           @notColon iny   
0463 5A46 80 ED                 bra   @count
0464 5A48 8A           @counted txa   
0465 5A49 8D D5 5E              sta   NumberOfSegments
0466 5A4C
0467 5A4C              *** Allocate 10 bytes per Item Struct that we'll need, and put a pointer
0468 5A4C              *** to this thing into [<ResultPtr] and <ItemStructList
0469 5A4C
0470 5A4C 1A                    inc   a                        ;extra item struct in case we're doing a Desktop item
0471 5A4D
0472 5A4D 48                    pha   
0473 5A4E 48                    pha                            ;space for Multiply result
0474 5A4F DA                    phx   
0475 5A50 F4 0A 00              pea   10
0476 5A53 A2 0B 09 22           _Multiply                      ;space needed is on stack
0477 5A5A 68                    pla   
0478 5A5B 7A                    ply                            ;ignore high word
0479 5A5C 20 79 5F              jsr   MyAllocate               ;returns pointer to locked handle in YX
0480 5A5F 90 03                 bcc   @ok
0481 5A61 82 BB FF              brl   ExitError
0482 5A64
0483 5A64 84 03        @ok      sty   <ItemStructList+2
0484 5A66 86 01                 stx   <ItemStructList
0485 5A68
0486 5A68 98                    tya   
0487 5A69 A0 04 00              ldy   #4
0488 5A6C 97 12                 sta   [<ResultPtr],y
0489 5A6E 88                    dey   
0490 5A6F 88                    dey   
0491 5A70 8A                    txa   
0492 5A71 97 12                 sta   [<ResultPtr],y
0493 5A73
0494 5A73              ;        ldy   #2                       ;Y is already 2
0495 5A73 A7 01                 lda   [<ItemStructList]
0496 5A75 AA                    tax   
0497 5A76 B7 01                 lda   [<ItemStructList],y
0498 5A78 85 03                 sta   <ItemStructList+2
0499 5A7A 86 01                 stx   <ItemStructList
0500 5A7C
0501 5A7C              *** Set up the highest item so far to be theStartingID minus one, since
0502 5A7C              *** we increment it before using it for the first time
0503 5A7C
0504 5A7C A5 16                 lda   <theStartingID
0505 5A7E 3A                    dec   a
0506 5A7F 87 12                 sta   [<ResultPtr]
0507 5A81
0508 5A81              ; Replace each seperator character (except the last trailing one) with
0509 5A81              ; a length byte, forming a series of PStrings.
0510 5A81
0511 5A81 A0 02 00              ldy   #2
0512 5A84
0513 5A84 E2 20                 sep   #$20
0514 5A86                       longa off
0515 5A86 A2 00 00     SearchLoop2 ldx   #0                    ; Initialize character counter
0516 5A89 CC CF 5E              cpy   Length                   ; Are we done?
0517 5A8C 90 03                 bcc   @1
0518 5A8E 82 AB 00              brl   SearchDone
0519 5A91
0520 5A91 8C CD 5E     @1       sty   Index                    ; Store position of separator character
0521 5A94 C8                    iny                            ;   and begin at next character
0522 5A95
0523 5A95 C2 20                 rep   #$20
0524 5A97 A7 12                 lda   [<ResultPtr]
0525 5A99 1A                    inc   a
0526 5A9A 87 12                 sta   [<ResultPtr]
0527 5A9C 8D D9 5E              sta   MenuItemID
0528 5A9F E2 20                 sep   #$20
0529 5AA1
0530 5AA1 B7 1E        SearchLoop1 lda   [<thePath],y          ; Search for separator characters
0531 5AA3 C9 3A                 cmp   #':'
0532 5AA5 F0 09                 beq   CreateLengthByte
0533 5AA7
0534 5AA7 CC CF 5E              cpy   Length                   ; End of string ?
0535 5AAA F0 04                 beq   CreateLengthByte
0536 5AAC
0537 5AAC C8                    iny   
0538 5AAD E8                    inx   
0539 5AAE 80 F1                 bra   SearchLoop1
0540 5AB0
0541 5AB0 5A           CreateLengthByte phy   
0542 5AB1
0543 5AB1 8A                    txa                            ; Replace the separator character
0544 5AB2 AC CD 5E              ldy   Index                    ;  with a length byte
0545 5AB5 97 1E                 sta   [<thePath],y
0546 5AB7
0547 5AB7                       longa on
0548 5AB7 C2 20                 rep   #$20
0549 5AB9
0550 5AB9              *** Store pointer to the current ItemStruct into the item template
0551 5AB9
0552 5AB9 A5 01                 lda   <ItemStructList
0553 5ABB 8D E1 5E              sta   ItemStructPtr
0554 5ABE A5 03                 lda   <ItemSTructList+2
0555 5AC0 8D E3 5E              sta   ItemStructPtr+2
0556 5AC3
0557 5AC3              ;       Store the ItemStruct's ItemFlag2
0558 5AC3
0559 5AC3 A9 00 80              lda   #$8000                   ; Item has an icon
0560 5AC6 87 01                 sta   [<itemStructList]
0561 5AC8
0562 5AC8              ;       Store the ItemStruct's ItemTitleRef pointer
0563 5AC8
0564 5AC8 A0 02 00              ldy   #2
0565 5ACB 18                    clc   
0566 5ACC AD CD 5E              lda   Index
0567 5ACF 65 1E                 adc   <thePath
0568 5AD1 97 01                 sta   [<itemStructList],y
0569 5AD3 C8                    iny   
0570 5AD4 C8                    iny   
0571 5AD5 A9 00 00              lda   #0
0572 5AD8 65 20                 adc   <thePath+2
0573 5ADA 97 01                 sta   [<itemStructList],y
0574 5ADC
0575 5ADC              ;       Store the ItemStruct's ItemIconRef pointer
0576 5ADC
0577 5ADC              *** Call GetSysIcon to get an icon
0578 5ADC
0579 5ADC 48                    pha   
0580 5ADD 48                    pha                            ;space for GetSysIcon result
0581 5ADE
0582 5ADE A5 22                 lda   <theFlags
0583 5AE0 29 04 00              and   #$0004                   ;Open/Closed folders bit
0584 5AE3 AA                    tax                            ;flags (bit 1-0:00=file icon)
0585 5AE4 A0 0F 00              ldy   #$000f                   ;Folder filetype
0586 5AE7 A7 12                 lda   [<ResultPtr]             ; If this is the first item, we need
0587 5AE9 C5 16                 cmp   <theStartingID           ; a disk icon
0588 5AEB D0 06                 bne   @aFile
0589 5AED
0590 5AED AC A8 5E              ldy   theDeviceID
0591 5AF0 A2 01 00              ldx   #1                       ;flag bits 1-0=01 for a device
0592 5AF3
0593 5AF3 DA           @aFile   phx                            ;flags
0594 5AF4 5A                    phy                            ;value (filetype or dev_id)
0595 5AF5 A9 00 00              lda   #0
0596 5AF8 48                    pha   
0597 5AF9 48                    pha                            ;aux value (long)
0598 5AFA A2 12 0F 22           _GetSysIcon 
0599 5B01 FA                    plx   
0600 5B02 68                    pla   
0601 5B03
0602 5B03              *** StoreIcon -- Icon is in AX
0603 5B03
0604 5B03 A0 08 00     StoreIcon ldy   #8                      ; Store ItemIconRef pointer
0605 5B06 97 01                 sta   [<itemStructList],y
0606 5B08 8A                    txa   
0607 5B09 88                    dey   
0608 5B0A 88                    dey   
0609 5B0B 97 01                 sta   [<itemStructList],y
0610 5B0D
0611 5B0D              *** Bump ItemStructList to the next one
0612 5B0D
0613 5B0D 18                    clc   
0614 5B0E A5 01                 lda   <itemStructList
0615 5B10 69 0A 00              adc   #10
0616 5B13 85 01                 sta   <itemStructList
0617 5B15 90 02                 bcc   @1
0618 5B17 E6 03                 inc   <itemStructList+2
0619 5B19              @1        
0620 5B19
0621 5B19              *** Finally!  Insert the item into the menu.
0622 5B19
0623 5B19 F4 00 00              pea   0                        ; refDescriptor (pointer)
0624 5B1C F4 02 00 F4           pushlong #MenuItem             ; menuItemTRef
0625 5B22 D4 18                 pei   <AfterItemID             ; 11-Jan-91 DAL
0626 5B24 D4 1A                 pei   <theMenuID
0627 5B26 A2 0F 3F 22           _InsertMItem2 
0628 5B2D              *** %%% check for error
0629 5B2D
0630 5B2D              * If flag bit 0 is set, the next item should be inserted after this one
0631 5B2D A5 22                 lda   <theFlags
0632 5B2F 4A                    lsr   a
0633 5B30 90 04                 bcc   @forward
0634 5B32 A7 12                 lda   [<ResultPtr]
0635 5B34 85 18                 sta   <AfterItemID             ;next one to insert after
0636 5B36              @forward  
0637 5B36
0638 5B36 E2 20                 sep   #$20
0639 5B38                       longa off
0640 5B38
0641 5B38 7A                    ply   
0642 5B39 82 4A FF              brl   SearchLoop2
0643 5B3C
0644 5B3C
0645 5B3C              ; We've inserted all the items
0646 5B3C
0647 5B3C              SearchDone  
0648 5B3C                       longa on
0649 5B3C C2 20                 rep   #$20
0650 5B3E
0651 5B3E A9 00 00              lda   #0
0652 5B41 48                    pha   
0653 5B42 48                    pha   
0654 5B43 D4 1A                 pei   <theMenuID
0655 5B45 A2 0F 1C 22           _CalcMenuSize 
0656 5B4C
0657 5B4C 6B                    rtl                            ;return error code in A
0658 5B4D
0659 5B4D              *
0660 5B4D              * GetDeviceID
0661 5B4D              *
0662 5B4D              * For the pathname at thePath, return the device id in theDeviceID
0663 5B4D              *
0664 5B4D A9 FF FF     GetDeviceID lda   #$ffff
0665 5B50 8D A8 5E              sta   theDeviceID
0666 5B53
0667 5B53 A6 1C                 ldx   <theInputDevNum
0668 5B55 A5 22                 lda   <theFlags
0669 5B57 29 08 00              and   #$0008                   ;bit 3 = theDevNum is valid
0670 5B5A D0 1C                 bne   @gotDevNum
0671 5B5C
0672 5B5C A5 1E                 lda   <thePath
0673 5B5E 8D 8E 5E              sta   GetDevNumPath
0674 5B61 A5 20                 lda   <thePath+2
0675 5B63 8D 90 5E              sta   GetDevNumPath+2
0676 5B66
0677 5B66 F4 02 00 F4           pushlong #GetDevNumParms 
0678 5B6C F4 20 20              pea   $2020                    ;GetDevNumber
0679 5B6F 22 B0 00 E1           jsl   $e100b0
0680 5B73 B0 16                 bcs   @exit
0681 5B75
0682 5B75 AE 92 5E              ldx   theDevNum
0683 5B78 8E 96 5E     @gotDevNum stx   DInfoDevNum
0684 5B7B E8                    inx                            ;added 22-Feb-91 DAL
0685 5B7C F0 0D                 beq   @exit                    ;added 22-Feb-91 DAL
0686 5B7E F4 02 00 F4           pushlong #DInfoParms 
0687 5B84 F4 2C 20              pea   $202C                    ;DInfo
0688 5B87 22 B0 00 E1           jsl   $e100b0
0689 5B8B 60           @exit    rts   
0690 5B8C
0691 5B8C 02 00        GetDevNumParms DC W:2
0692 5B8E 00 00 00 00  GetDevNumPath DC L:0
0693 5B92 00 00        theDevNum DC W:0
0694 5B94
0695 5B94 08 00        DInfoParms DC W:8                       ;8 parameters
0696 5B96 00 00        DInfoDevNum DC W:0
0697 5B98 AA 5E 02 00           DC L:deviceName
0698 5B9C 00 00                 DC W:0                         ;characteristics
0699 5B9E 00 00 00 00           DC L:0                         ;total blocks
0700 5BA2 00 00                 DC W:0                         ;slot num
0701 5BA4 00 00                 DC W:0                         ;unit num
0702 5BA6 00 00                 DC W:0                         ;version
0703 5BA8 00 00        theDeviceID DC W:0                      ;device id
0704 5BAA
0705 5BAA 23 00        deviceName DC W:35                      ;room for a 31-character device name
0706 5BAC 00 00 00 00           DS B:33
0707 5BCD
0708 5BCD
0709 5BCD
0710 5BCD 00 00        Index    DS W:1                         ; Stores location of separator char
0711 5BCF 00 00        Length   DS W:1                         ; Stores length of original pathname string
0712 5BD1 00 00 00 00  TempHdl  DS L:1
0713 5BD5
0714 5BD5 00 00        NumberOfSegments DC W:0                 ;number of items we're going to insert
0715 5BD7
0716 5BD7              MenuItem                                ; Menu Item Template
0717 5BD7 00 00                 DC W:$0000                        ; version
0718 5BD9 00 00        MenuItemID DC W:$0000                      ; itemID
0719 5BDB 00                    DC B:$00                          ; itemChar
0720 5BDC 00                    DC B:$00                          ; itemAltChar
0721 5BDD 00 00                 DC W:$0000                        ; itemCheck  / additional ItemStruct
0722 5BDF 20 04                 DC W:%0000010000100000            ; itemFlag   =   <  XOR mode)
0723 5BE1 00 00 00 00  ItemStructPtr DC L:$00000000               ; itemStructRef \ ItemStrucRef is pointer
0724 5BE5
0725 5BE5              *
0726 5BE5              * ExpandThePath
0727 5BE5              *
0728 5BE5              * Input: pointer to user's path in <thePath
0729 5BE5              *
0730 5BE5              * Output: pointer to a fully expanded path, in our own handle, in <thePath
0731 5BE5              *         A/Carry=error code
0732 5BE5              *
0733 5BE5 A5 20        ExpandThePath lda   <thePath+2
0734 5BE7 A4 1E                 ldy   <thePath
0735 5BE9 8D 63 5F              sta   ep1Input+2
0736 5BEC 8C 61 5F              sty   ep1Input
0737 5BEF 8D 71 5F              sta   ep2Input+2
0738 5BF2 8C 6F 5F              sty   ep2Input
0739 5BF5
0740 5BF5              *** First, do an expand path just to see how much room we need
0741 5BF5 F4 02 00 F4           pushlong #FirstExpPath 
0742 5BFB F4 0E 20              pea   $200E                    ;ExpandPath
0743 5BFE 22 B0 00 E1           jsl   $e100b0
0744 5C02 90 05                 bcc   @noError                 ;added 7-Dec-91
0745 5C04 C9 4F 00              cmp   #$4f
0746 5C07 D0 54                 bne   @error
0747 5C09
0748 5C09              @noError  
0749 5C09 AD 6B 5F              lda   SizeNeeded
0750 5C0C 18                    clc   
0751 5C0D 69 04 00              adc   #4
0752 5C10 8D 6B 5F              sta   SizeNeeded
0753 5C13 20 79 5F              jsr   MyAllocate
0754 5C16 B0 45                 bcs   @error
0755 5C18
0756 5C18 84 20                 sty   <thePath+2
0757 5C1A 86 1E                 stx   <thePath
0758 5C1C
0759 5C1C              *** Store a copy of the handle into [<ResultPtr],6 so the caller
0760 5C1C              *** can dispose of it when they're ready to.
0761 5C1C 98                    tya   
0762 5C1D A0 08 00              ldy   #6+2
0763 5C20 97 12                 sta   [<ResultPtr],y
0764 5C22 88                    dey   
0765 5C23 88                    dey   
0766 5C24 8A                    txa   
0767 5C25 97 12                 sta   [<ResultPtr],y
0768 5C27
0769 5C27              *** Deref the handle (it's locked & fixed)
0770 5C27 A7 1E                 lda   [<thePath]
0771 5C29 AA                    tax   
0772 5C2A A0 02 00              ldy   #2
0773 5C2D B7 1E                 lda   [<thePath],y
0774 5C2F 85 20                 sta   <thePath+2
0775 5C31 86 1E                 stx   <thePath
0776 5C33 8D 75 5F              sta   ep2Output+2
0777 5C36 8E 73 5F              stx   ep2Output
0778 5C39
0779 5C39 AD 6B 5F              lda   SizeNeeded
0780 5C3C 87 1E                 sta   [<thePath]
0781 5C3E
0782 5C3E F4 02 00 F4           pushlong #SecondExpPath 
0783 5C44 F4 0E 20              pea   $200E                    ;ExpandPath
0784 5C47 22 B0 00 E1           jsl   $e100b0                  ;keep error code
0785 5C4B
0786 5C4B 48                    pha   
0787 5C4C 18                    clc   
0788 5C4D A5 1E                 lda   <thePath
0789 5C4F 69 02 00              adc   #2
0790 5C52 85 1E                 sta   <thePath
0791 5C54 90 02                 bcc   @1
0792 5C56 E6 20                 inc   <thePath+2
0793 5C58 68           @1       pla   
0794 5C59
0795 5C59 C9 01 00              cmp   #1                       ;condition carry
0796 5C5C 60                    rts   
0797 5C5D
0798 5C5D 38           @error   sec   
0799 5C5E 60                    rts   
0800 5C5F
0801 5C5F 02 00        FirstExpPath DC W:2
0802 5C61 00 00 00 00  ep1Input DC L:0
0803 5C65 69 5F 02 00           DC L:theBuffer
0804 5C69 04 00        theBuffer DC W:4
0805 5C6B 00 00        SizeNeeded DC W:0
0806 5C6D
0807 5C6D 03 00        SecondExpPath DC W:3
0808 5C6F 00 00 00 00  ep2Input DC L:0
0809 5C73 00 00 00 00  ep2Output DC L:0
0810 5C77 00 00                 DC W:0                         ;don't convert to uppercase
0811 5C79
0812 5C79              *
0813 5C79              * MyAllocate--size in A, returns handle in YX (or SEC, A=error)
0814 5C79              *
0815 5C79 48           MyAllocate pha   
0816 5C7A 48                    pha                            ;space for result
0817 5C7B F4 00 00              pea   0                        ;high word of size
0818 5C7E 48                    pha                            ;size
0819 5C7F A0 06 00              ldy   #MyID
0820 5C82 B7 05                 lda   [<MenuWAP],y
0821 5C84 48                    pha                            ;mem id
0822 5C85 F4 10 C0              pea   $c010                    ;locked, fixed, no bank cross
0823 5C88 48                    pha   
0824 5C89 48                    pha                            ;location pointer (ignored)
0825 5C8A A2 02 09 22           _NewHandle 
0826 5C91 FA                    plx   
0827 5C92 7A                    ply   
0828 5C93 60                    rts   
0829 5C94
0830 5C94                       EndP 
0831 5C94
0832 5C94                       END   
